/*
 * BSD License
 *  ( http://www.opensource.org/licenses/bsd-license.html )
 *
 * Software copyright (c) 2002, k` (agggka@hotmail.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution
 *  3. The name of the author may not be used to endorse or promote
 *     products derived from this software without specific prior
 *     written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 
 * Created on 7 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.simpleSwing;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

import java.awt.* ;

import javax.swing.*;
import javax.swing.plaf.metal.MetalLookAndFeel;


/* # classe ALookAndFeel - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 * Variante du Look and Feel 'Metal', ici aucune fonte grasse n'est employee
 *  par defaut dans les menus (CheckBox, RadioButton, ...).
 * 
 * @author        k
 * @version       x.xx, 07/21/2002
 * @since         JDK1.2 (?)
 */
public class ALookAndFeel extends MetalLookAndFeel
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

  public static String[] menuKeys=
    new String[] { "CheckBoxMenuItem.acceleratorFont",
                   "CheckBoxMenuItem.font",
                   "Menu.acceleratorFont",
                   "Menu.font",
                   "MenuBar.font",
                   "MenuItem.acceleratorFont",
                   "MenuItem.font",
                   "RadioButtonMenuItem.acceleratorFont",
                   "RadioButtonMenuItem.font" };

 
  public static String[] componentsKeys=
    new String[] { "Button.font",
                   "CheckBox.font",
                   "ColorChooser.font",
                   "ComboBox.font",
                   "InternalFrame.titleFont",
                   "Label.font",
                   "List.font",
                   "OptionPane.font",
                   "Panel.font",
                   "PasswordField.font",
                   "PopupMenu.font",
                   "ProgressBar.font",
                   "RadioButton.font",
                   "ScrollPane.font",
                   "TabbedPane.font",
                   "Table.font",
                   "TableHeader.font",
                   "TitledBorder.font",
                   "ToggleButton.font",
                   "ToolBar.font",
                   "ToolTip.font",
                   "Tree.font",
                   "Viewport.font" };


  public static String[] textComponentsKeys=
    new String[] { "EditorPane.font",
                   "TextArea.font",
                   "TextField.font",
                   "TextPane.font" };



 /* # getter / setter - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

  public String getName()
  { return "Metal 'simpleMetal'"; }


  public String getDescription()
  { return "Metal (java) Look and Feel, with PLAIN font style"; }



 /* # methodes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

  protected void initComponentDefaults(UIDefaults table)
  { super.initComponentDefaults(table);

    Object[] defaults= new Object[ 2*menuKeys.length ];

    for(int i=menuKeys.length, j=0 ; i-->0 ;)
    { defaults[j++]= menuKeys[i];
      defaults[j++]= table.getFont( menuKeys[i] ).deriveFont(Font.PLAIN, 12);
    }
    table.putDefaults(defaults);
  }


}// public class ALookAndFeel extends MetalLookAndFeel


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */