/*
 * BSD License
 *  ( http://www.opensource.org/licenses/bsd-license.html )
 *
 * Software copyright (c) 2002, k` (agggka@hotmail.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution
 *  3. The name of the author may not be used to endorse or promote
 *     products derived from this software without specific prior
 *     written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 
 * Created on 7 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.simpleSwing;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.JFrame;


/* # classe AFrame - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 * 
 * @author                 k` - agggka@hotmail.com
 * @version                x.xx, 07/21/2002
 * @since                  JDK1.2 (?)
 */
public class AFrame extends JFrame implements WindowListener
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Conteneur courant, 'interieur' de la fenetre.
  */
  protected Container contentPane;



 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Creation d'une fenetre, sans titre, de dimension nulle, situee au point
  *  (0,0) du peripherique d'affichage par defaut.
  */
  public AFrame()
  { this(null, new Rectangle(), null); }


 /**
  * Creation d'une fenetre, sans titre, la position occupe sur le peripherique
  *  d'affichage par defaut est donnee par le point p, les dimensions sont
  *  nulles.
  *
  * @param p                coin superieur gauche de la fenetre
  */
  public AFrame(Point p)
  { this(null, new Rectangle(p), null); }


 /**
  * Creation d'une fenetre, sans titre, situee au point (0,0), l'espace
  *  occupe sur le peripherique d'affichage par defaut est donne par la
  *  dimension d.
  *
  * @param d                largeur et hauteur de la fenetre
  */
  public AFrame(Dimension d)
  { this(null, new Rectangle(d), null); }


 /**
  * Creation d'une fenetre, sans titre, la position et l'espace occupes sur
  *  le peripherique d'affichage par defaut sont donnes par le rectangle r.
  *
  * @param r                rectangle occupe par la fenetre sur l'ecran
  */
  public AFrame(Rectangle r)
  { this(null, r, null); }


 /**
  * Creation d'une fenetre, sans titre, de dimension nulle, situee au point
  *  (0,0) du peripherique d'affichage dont les caracteristques sont
  *  fournies par gc.
  * 
  * @param gc               caracteristiques du peripherique d'affichage
  */
  public AFrame(GraphicsConfiguration gc)
  { this(null, new Rectangle(), gc); }


 /**
  * Creation d'une fenetre, de titre title, de dimension nulle, situee au
  *  point (0,0) du peripherique d'affichage par defaut.
  * 
  * @param title            titre de la fenetre
  */
  public AFrame(String title)
  { this(title, new Rectangle(), null); }


 /**
  * Creation d'une fenetre, de titre title, la position occupe sur le
  *  peripherique d'affichage par defaut est donnee par le point p,
  *  les dimensions sont nulles.
  *
  * @param title            titre de la fenetre
  * @param p                coin superieur gauche de la fenetre
  */
  public AFrame(String title, Point p)
  { this(title, new Rectangle(p), null); }


 /**
  * Creation d'une fenetre, de titre title, situee au point (0,0), l'espace
  *  occupe sur le peripherique d'affichage par defaut est donne par la
  *  dimension d.
  *
  * @param title            titre de la fenetre
  * @param d                largeur et hauteur de la fenetre
  */
  public AFrame(String title, Dimension d)
  { this(title, new Rectangle(d), null); }


 /**
  * Creation d'une fenetre, de titre title, la position et l'espace occupes
  *  sur le peripherique d'affichage par defaut sont donnes par le
  *  rectangle r.
  * 
  * @param title            titre de la fenetre
  * @param r                rectangle occupe par la fenetre sur l'ecran
  */
  public AFrame(String title, Rectangle r)
  { this(title, r, null); }


 /**
  * Creation d'une fenetre, de titre title, de dimension nulle, situee au
  *  point (0,0) du peripherique d'affichage dont les caracteristques sont
  *  fournies par gc.
  * 
  * @param title            titre de la fenetre
  * @param gc               caracteristiques du peripherique d'affichage
  */
  public AFrame(String title, GraphicsConfiguration gc)
  { this(title, new Rectangle(), gc); }


 /**
  * Creation d'une fenetre, de titre title, la position occupe sur le
  *  peripherique d'affichage par defaut est donnee par le point p,
  *  les dimensions sont nulles.
  *
  * @param title            titre de la fenetre
  * @param p                coin superieur gauche de la fenetre
  */
  public AFrame(String title, Point p, GraphicsConfiguration gc)
  { this(title, new Rectangle(p), gc); }


 /**
  * Creation d'une fenetre, de titre title, situee au point (0,0), la
  *  dimension d donne l'espace occupe sur le peripherique d'affichage dont
  *  les caracteristques sont fournies par gc.
  *
  * @param title            titre de la fenetre
  * @param d                largeur et hauteur de la fenetre
  * @param gc               caracteristiques du peripherique d'affichage
  */
  public AFrame(String title, Dimension d, GraphicsConfiguration gc)
  { this(title, new Rectangle(d), gc); }


 /**
  * Creation d'une fenetre, de titre title, le rectangle r donne la position
  *  et l'espace occupes sur le peripherique d'affichage dont les
  *  caracteristques sont fournies par gc.
  * 
  * @param title            titre de la fenetre
  * @param r                rectangle occupe par la fenetre sur l'ecran
  * @param gc               caracteristiques du peripherique d'affichage
  */
  public AFrame(String title, Rectangle r, GraphicsConfiguration gc)
  { super(title, gc);

    this.contentPane= this.getContentPane();
    this.addWindowListener(this);
    this.pack();

    this.setBounds(r);
  }



 /* # getter / setter - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * 
  */
  public void setBounds(int x, int y, int width, int height)
  { Insets insets= this.getInsets();
    super.setBounds(x, y, width + insets.left, height + insets.top);
  }


 /**
  * 
  */
  public void setBounds(Rectangle r)
  { this.setBounds(r.x, r.y, r.width, r.height); }


 /**
  * Modifie le <code>contentPane</code> de la fenetre.
  * 
  * @param contentPane      le nouveau <code>Container</code>
  */
  public void setContentPane(Container contentPane)
  { super.setContentPane(contentPane);
    this.contentPane= this.getContentPane();
  }



 /* # methodes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Liberation des ressources utilisees par la fenetre et son contenu.
  * <br />pour etre a nouveau affichable(s), la fenetre (et son contenu)
  *  doi(ven)t etre reconstruit(s).
  */
  public void dispose()
  { super.dispose();
    try
    { this.finalize(); }
    catch(Throwable t)
    { /* do nothing */ }
  }


 /**
  * Declenche le calcul de la taille souhaitee ("preferred size") de la
  *  fenetre, et l'organisation du contenu de la fenetre.
  * <br />Appel de la methode <code>prepare</code>.
  */
  public void pack()
  { this.prepare();
    super.pack();
  }


 /**
  * Action(s) a realiser a la creation de la fenetre, typiquement:
  *  la creation et l'organisation du contenu de la fenetre.
  * <br />Methode initialement vide.
  */
  protected void prepare()
  { /* there is nothing here for sure */ }


 /* (non-Javadoc)
  * @see java.awt.event.WindowListener#windowActivated(java.awt.event.WindowEvent)
  */
  public void windowActivated(WindowEvent e)
  { /* sorry, nothing here */ }


 /* (non-Javadoc)
  * @see java.awt.event.WindowListener#windowClosed(java.awt.event.WindowEvent)
  */
  public void windowClosed(WindowEvent e)
  { /* neither here */ }


 /* (non-Javadoc)
  * @see java.awt.event.WindowListener#windowClosing(java.awt.event.WindowEvent)
  */
  public void windowClosing(WindowEvent e)
  { /* please don't ask */ }


 /* (non-Javadoc)
  * @see java.awt.event.WindowListener#windowDeactivated(java.awt.event.WindowEvent)
  */
  public void windowDeactivated(WindowEvent e)
  { /* kinda stuborn, aren't you ? */ }


 /* (non-Javadoc)
  * @see java.awt.event.WindowListener#windowDeiconified(java.awt.event.WindowEvent)
  */
  public void windowDeiconified(WindowEvent e)
  { /* there was something here, but it's gone now */ }


 /* (non-Javadoc)
  * @see java.awt.event.WindowListener#windowIconified(java.awt.event.WindowEvent)
  */
  public void windowIconified(WindowEvent e)
  { /* then, how's your mother ? */ }


 /* (non-Javadoc)
  * @see java.awt.event.WindowListener#windowOpened(java.awt.event.WindowEvent)
  */
  public void windowOpened(WindowEvent e)
  { /* whoa, check the clock, gotta go, bye! */ }


}// public class AFrame extends JFrame implements WindowListener


/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */