/*
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 
 * Created on 11 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.simpleSwing;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

import javax.swing.Action;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;



/* # classe AAction  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 *
 * @author k
 */
public abstract class AAction extends AbstractAction
{

 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * 
  */
  public AAction()
  { this(null, null, 0, null); }


 /**
  * 
  * 
  * @param name
  */
  public AAction(String name)
  { this(name, null, 0, null); }


 /**
  * 
  * 
  * @param name
  * @param icon
  */
  public AAction(String name, Icon icon)
  { this(name, icon, 0, null); }


 /**
  * 
  * 
  * @param name
  * @param mnemonic
  */
  public AAction(String name, int mnemonic)
  { this(name, null, mnemonic, null); }


 /**
  * 
  * 
  * @param name
  * @param icon
  * @param mnemonic
  */
  public AAction(String name, Icon icon, int mnemonic)
  { this(name, icon, mnemonic, null); }


 /**
  * 
  * 
  * @param name
  * @param mnemonic
  * @param modifier
  */
  public AAction(String name, int mnemonic, int modifier)
  { this(name, null, mnemonic, KeyStroke.getKeyStroke(mnemonic, modifier)); }


 /**
  * 
  * 
  * @param name
  * @param mnemonic
  * @param keyCode
  * @param modifier
  */
  public AAction(String name, int mnemonic, int keyCode, int modifier)
  { this(name, null, mnemonic, KeyStroke.getKeyStroke(keyCode, modifier)); }


 /**
  * 
  * 
  * @param name
  * @param mnemonic
  * @param keyStroke
  */
  public AAction(String name, int mnemonic, KeyStroke keyStroke)
  { this(name, null, mnemonic, keyStroke); }


 /**
  * 
  * 
  * @param name
  * @param icon
  * @param mnemonic
  * @param modifier
  */
  public AAction(String name, Icon icon, int mnemonic, int modifier)
  { this(name, icon, mnemonic, KeyStroke.getKeyStroke(mnemonic, modifier)); }


 /**
  * 
  * 
  * @param name
  * @param icon
  * @param mnemonic
  * @param keyCode
  * @param modifier
  */
  public AAction(String name, Icon icon, int mnemonic, int keyCode, int modifier)
  { this(name, icon, mnemonic, KeyStroke.getKeyStroke(keyCode, modifier)); }


 /**
  * 
  * 
  * @param name
  * @param icon
  * @param mnemonic
  * @param keyStroke
  */
  public AAction(String name, Icon icon, int mnemonic, KeyStroke keyStroke)
  { super(name, icon);
    this.setMnemonic(mnemonic);
    this.setAccelerator(keyStroke);
  }



 /* # getter / setter - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * 
  */
  public void setMnemonic(int mnemonic)
  { this.putValue(Action.MNEMONIC_KEY, new Integer(mnemonic)); }


 /**
  * 
  * 
  * @param keyStroke
  */
  public void setAccelerator(KeyStroke keyStroke)
  { this.putValue(Action.ACCELERATOR_KEY, keyStroke); }


 /**
  * 
  * 
  * @param keyCode
  * @param modifier
  */
  public void setAccelerator(int keyCode, int modifier)
  { this.setAccelerator(KeyStroke.getKeyStroke(keyCode, modifier)); }


}// public abstract class AAction extends AbstractAction



/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */