/*
 * BSD License
 *  ( http://www.opensource.org/licenses/bsd-license.html )
 *
 * Software copyright (c) 2002, k` (agggka@hotmail.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution
 *  3. The name of the author may not be used to endorse or promote
 *     products derived from this software without specific prior
 *     written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *
 * Created on 12 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.isola.skin.redrobot;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

import javax.swing.AbstractButton;
import javax.swing.JDialog;

import org.skreel.k.isola.Mediator;
import org.skreel.k.isola.core.*;


/* # classe GraphicMediator  - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 *
 * @author work
 */
public class SkinMediator extends Mediator
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

// TODO : passer ces valeurs dans la classe ComputerPlayer
public static final int SKILL_RANDOM= 0;
public static final int SKILL_SIMPLE= 1;
public static final int SKILL_MINMAX= 2;

 /**
  * Reference facile d'acces a la fenetre affichant le jeu.
  */
  protected Skin skin;


 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Cree un motif Mediateur gerant les interactions des controles de
  *  l'interface graphique.
  */
  public SkinMediator()
  { super(); }



 /* # getter / setter - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Determine si l'element referencee par key est utilisable.
  *
  * @param key              cle d'identification du composant.
  * @param enabled          true si le composant est utilisable.
  */  
  private void setButtonEnabled(String key, boolean enabled)
  { Object machin= this.hashtable.get(key);
    try
    { ((AbstractButton) machin).setEnabled(enabled); }
    catch (Exception e)
    { /* time for me is nothing cause I'm counting no age */ }
  }


 /**
  * Determine si l'element referencee par key est selectionne.
  *
  * @param key              cle d'identification du composant.
  * @param selected         true si le composant est utilisable.
  */  
  private void setButtonSelected(String key, boolean selected)
  { Object machin= this.hashtable.get(key);
    try
    { ((AbstractButton) machin).setSelected(selected); }
    catch (Exception e)
    { /* these aren't the drone you're looking for */ }
  }


 /**
  * Determine si la boite de dialogue identifiee par la cle key est a
  *  afficher, elle est en meme temps (re) positionnee par rapport a la
  *  fenetre principale de l'application.
  *
  * @param key              cle d'identification du composant.
  * @param visible          true si la boite de dialogue est a afficher
  */
  private void setDialogVisible(String key, boolean visible)
  { Object  machin= this.hashtable.get(key);
    JDialog dialog;

    try
    { dialog= (JDialog) machin;
      dialog.setLocation(skin.getX() + 70, skin.getY() - 6);
      dialog.setVisible(visible);
    }
    catch (Exception e)
    { /* Mother dear you'll never be my sister */ }
  }


 /**
  * Determine lequel des deux joueurs debute la partie.
  *
  * @param playerId         identifiant de joueur
  */
  public void setFirstPlayer(int playerId)
  { super.setFirstPlayer(playerId);

    if (Game.PLAYER_ONE == playerId)
    { this.setButtonSelected("MenuItem_P1_First", true); }
    else
    { this.setButtonSelected("MenuItem_P2_First", true); }
  }


 /**
  * Organise l'etat des composants reglant la nature du joueur playerId.
  *  Si ce joueur est humain, alors il n'est pas coherent d'avoir acces au
  *  reglage de la force de la machine pour ce joueur.
  *
  * @param playerId         identifiant de joueur
  * @param value            true si le joueur est humain
  */
  public void setPlayerHuman(int playerId, boolean value)
  { super.setPlayerHuman(playerId, value);

    if (Game.PLAYER_ONE == playerId)
    { this.setButtonSelected("MenuItem_P1_Human"   ,  value);
      this.setButtonSelected("MenuItem_P1_Computer", !value);
      this.setButtonEnabled("Menu_P1_setSkill"     , !value);
    }
    else
    { this.setButtonSelected("MenuItem_P2_Human"   ,  value);
      this.setButtonSelected("MenuItem_P2_Computer", !value);
      this.setButtonEnabled("Menu_P2_setSkill"     , !value);
    }
  }


 /**
  * Determine la configuration du joueur considere.
  *
  * @param playerId         identifiant de joueur
  * @param skill            force du joueur (valable pour une IA)
  */
  public void setPlayerSkill(int playerId, int skill)
  { super.setPlayerSkill(playerId, skill);

    switch (skill)
    { case SKILL_MINMAX :
        if (Game.PLAYER_ONE == playerId)
        { this.setButtonSelected("MenuItem_P1_MinMax", true); }
        else
        { this.setButtonSelected("MenuItem_P2_MinMax", true); }
        break;

      case SKILL_SIMPLE :
        if (Game.PLAYER_ONE == playerId)
        { this.setButtonSelected("MenuItem_P1_Simple", true); }
        else
        { this.setButtonSelected("MenuItem_P2_Simple", true); }
        break;

      default :
        if (Game.PLAYER_ONE == playerId)
        { this.setButtonSelected("MenuItem_P1_Random", true); }
        else
        { this.setButtonSelected("MenuItem_P2_Random", true); }
    }// switch (skill)
  }


 /* # methodes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Declaration de la fenetre au Mediateur.
  *
  * @param key              cle d'identification du composant.
  * @param skin             fenetre d'affichage du jeu.
  */
  public void register(String key, Skin skin)
  { this.skin= skin; }


 /**
  * Initialisation de l'etat des composants.
  */
  public void initialize()
  { super.initialize();

    this.setButtonEnabled("MenuItem_Restart", false);
    this.setButtonEnabled("MenuItem_Undo"   , false);
    this.setButtonEnabled("MenuItem_Redo"   , false);
    this.setPlayerHuman(Game.PLAYER_ONE, true);
    this.setPlayerHuman(Game.PLAYER_TWO, false);
    this.setPlayerSkill(Game.PLAYER_ONE, SKILL_MINMAX);
    this.setPlayerSkill(Game.PLAYER_TWO, SKILL_MINMAX);
    this.setFirstPlayer(Game.PLAYER_ONE);

    try
    { this.skin.show(); }
    catch (Exception e)
    { /* Get the cool shoe shine */ }
  }


 /**
  * Affiche les changement survenu a l'objet observe.
  *
  * @param gameState        l'etat courant du dit jeu observe
  */
  protected void update(GameState gameState)
  { switch (gameState.getGameContext())
    { case Game.PLAYER_ONE_MOVE :
        break;

      case Game.PLAYER_ONE_PUSH :
        break;

      case Game.PLAYER_ONE_WINS :
        break;

      case Game.PLAYER_TWO_MOVE :
        break;

      case Game.PLAYER_TWO_PUSH :
        break;

      case Game.PLAYER_TWO_WINS :
        break;

      case Game.PLAYER_ONE_WRNG :
        break;

      case Game.PLAYER_TWO_WRNG :
        break;


      default :
        /* seems there's nothing much left to do boy */
    }// switch (gameState.getGameContext())
  }


 /**
  * Instructions a realiser quand l'utilisateur demande une
  *  nouvelle partie.
  */
  public void newgame()
  { super.newgame();

    this.setButtonEnabled("MenuItem_Restart", true);
  }


 /**
  * Instructions a realiser quand l'utilisateur demande a rejouer
  *  la partie.
  */
  public void restart()
  { super.restart();

  }


 /**
  * Instructions a realiser quand l'utilisateur demande l'annulation
  *  du dernier coup.
  */
  public void undo()
  { super.undo();

  }


 /**
  * Instructions a realiser quand l'utilisateur demande a refaire
  *  le dernier coup annule.
  */
  public void redo()
  { super.redo();

  }


 /**
  * Instructions a realiser quand l'utilisateur demande l'arret
  *  de l'application.
  */
  public void quit()
  { try
    { this.skin.dispose(); }
    catch (Exception e)
    { /* Get the cool shoe shine */ }

    super.quit();
  }


 /**
  * Instructions a realiser quand l'utilisateur demande l'affichage
  *  de l'aide du jeu.
  */
  void displayRules()
  { this.setDialogVisible("Dialog_Rules", true); }


 /**
  * Instructions a realiser quand l'utilisateur demande l'affichage
  *  des informations relatives a l'application.
  */
  void displayAbout()
  { this.setDialogVisible("Dialog_About", true); }


}// public class GraphicMediator extends Mediator



/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */