/*
 * BSD License
 *  ( http://www.opensource.org/licenses/bsd-license.html )
 *
 * Software copyright (c) 2002, k` (agggka@hotmail.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution
 *  3. The name of the author may not be used to endorse or promote
 *     products derived from this software without specific prior
 *     written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *
 * Created on 11 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.isola.skin.redrobot;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;


/* # classe Skin - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 *
 * @author k
 */
public final class Skin extends JFrame
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Dimensions de la fenetre d'affichage.
  */
  private final static Dimension DIMENSION= new Dimension(475, 285);

 /**
  * Titre de la fenetre.
  */
  private final static String    WIN_TITLE= "Isola (feat. Red Robot)";



 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Construit et initialise une fenetre graphique dont le coin haut gauche
  *  est au point (x,y) du peripherique d'affichage.
  *
  * @param x                abscisse du coin superieur gauche de la fenetre
  * @param y                ordonnee du coin superieur gauche de la fenetre
  */
  public Skin(int x, int y, SkinMediator mediator)
  { super(Skin.WIN_TITLE, null);
    Container contentPane;

    contentPane= this.getContentPane();
    contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
    contentPane.setBackground(java.awt.Color.WHITE);
    contentPane.add(this.createMainArea(mediator));

    this.setJMenuBar(new Menubar(mediator));
    this.setDefaultCloseOperation(DISPOSE_ON_CLOSE); 
    this.setResizable(false);
    this.pack();

    this.setLocation(x, y);
    this.setSize(Skin.DIMENSION);

    mediator.register("mainFrame", this);
    mediator.register("Dialog_Rules", new RulesDialog(this));
    mediator.register("Dialog_About", new AboutDialog(this));
  }




 /* # getter / setter - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Redimensionne la fenetre, en tenant compte des bordures
  *  de cette derniere.
  *
  * @param d
  */
  public final void setSize(Dimension d)
  { Insets insets= this.getInsets();
    super.setSize(d.width + insets.left, d.height + insets.top);
  }



 /* # methodes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Cree et agence le contenu principal de la fenetre
  */
  private final Container createMainArea(SkinMediator mediator)
  { Box     retour;
    Box     hrzBox, vrtBox;

   // createRigidArea nous permet de forcer la mise en "page"
    retour= new Box(BoxLayout.X_AXIS);
    retour.add( Box.createRigidArea(new Dimension(10, 260)) );
      vrtBox= new Box(BoxLayout.Y_AXIS);
      vrtBox.add( Box.createRigidArea(new Dimension(320, 10)) );
        hrzBox= new Box(BoxLayout.X_AXIS);
        hrzBox.add( Box.createRigidArea(new Dimension(0, 240)) );
        hrzBox.add( new GameBoard(mediator) );
        hrzBox.add( Box.createRigidArea(new Dimension(0, 240)) );
      vrtBox.add( hrzBox );
    retour.add(vrtBox);
    retour.add( Box.createRigidArea(new Dimension( 8, 260)) );
      vrtBox= new Box(BoxLayout.Y_AXIS);
      vrtBox.add( Box.createRigidArea(new Dimension(135, 0)) );
      vrtBox.add( new SidePanel(mediator) );
    retour.add(vrtBox);

    return (retour);
  }



}// public class Skin extends JFrame



/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */