/*
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 
 * Created on 11 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.isola.skin.redrobot;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JPanel;
import javax.swing.Timer;

import edu.umbc.enorth.* ;

import org.skreel.k.isola.core.*;


/* # classe GraphicSidePanel - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 *
 * @author work
 */
class SidePanel extends JPanel
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Certains message ne doivent etre affiche que quelques secondes.
  */
  private Timer timer;

 /**
  * Les images a afficher.
  */
  private BasicTile[] tiles;


 /**
  * Cache: contexte du jeu.
  */
  private int gameContext;



 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Cree un panneau 'decoratif'.
  */
  public SidePanel(SkinMediator mediator)
  { this.gameContext= Game.NO_GAME_CONTEXT;

    this.timer= new Timer(900, new ActionListener()
      { public void actionPerformed(ActionEvent e)
        { SidePanel.this.update(SidePanel.this.gameContext); }
      });
    this.timer.setRepeats(false);
    this.addMouseListener(new innerMouseListener());

    mediator.register("sidePanel", this);
  }



 /* # methodes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Chargement des images, utilisation d'un <code>MediaTracker</code>
  *  pour un chargement EFFECTIF.
  */
  private final void loadRessources()
  { Toolkit       toolkit= java.awt.Toolkit.getDefaultToolkit();
    MediaTracker  tracker= new MediaTracker(this);
    Image         courant;

    this.tiles= new BasicTile[3];

    courant= toolkit.getImage( SidePanel.class.getResource("/images/sidepanel/red_tilemap0.gif") );
    this.tiles[0]= new BasicTile(courant, 135,  89);
    tracker.addImage(courant, 0);
    courant= toolkit.getImage( SidePanel.class.getResource("/images/sidepanel/red_tilemap1.gif") );
    this.tiles[1]= new BasicTile(courant,  66, 171);
    tracker.addImage(courant, 1);
    courant= toolkit.getImage( SidePanel.class.getResource("/images/sidepanel/red_tilemap2.gif") );
    this.tiles[2]= new BasicTile(courant,  69, 171);
    tracker.addImage(courant, 2);

    try
    { tracker.waitForAll(); }
    catch(InterruptedException ie)
    { /* bah, this is hopeless */ }
  }


 /**
  *
  * @param gameCcontext     contexte du jeu
  */
  void update(int gameContext)
  { switch (gameContext)
    { case Game.PLAYER_ONE_MOVE :
        this.gameContext= gameContext;
        break;

      case Game.PLAYER_ONE_PUSH :
        this.gameContext= gameContext;
        break;

      case Game.PLAYER_ONE_WINS :
        this.gameContext= gameContext;
        break;

      case Game.PLAYER_TWO_MOVE :
        this.gameContext= gameContext;
        break;

      case Game.PLAYER_TWO_PUSH :
        this.gameContext= gameContext;
        break;

      case Game.PLAYER_TWO_WINS :
        this.gameContext= gameContext;
        break;

      case Game.PLAYER_ONE_WRNG :
      case Game.PLAYER_TWO_WRNG :
        this.tiles[0].jumpToTile(0, 2);
        this.tiles[1].jumpToTile(1, 0);
        this.tiles[2].jumpToTile(0, 0);
        this.timer.start();
        break;

      default :
        this.gameContext= Game.NO_GAME_CONTEXT;
        this.tiles[0].jumpToTile(0, 0);
        this.tiles[1].jumpToTile(0, 0);
        this.tiles[2].jumpToTile(0, 0);

    }// switch (gameContext)
    this.repaint();
  }


 /**
  * Affichage du 'sidePanel'.
  *
  * @param g                "cible" affichant le dessin
  */
  public void paint(Graphics g)
  { if (null == tiles)
    { g.drawString("loading images...", 10, 130);
      this.loadRessources();
    }// if (null == tiles)

    this.tiles[0].drawTo(g,  0,  0);
    this.tiles[1].drawTo(g,  0, 89);
    this.tiles[2].drawTo(g, 66, 89);
  }



 /* # inner Classes - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Gestion du click sur le sidePanel. Un petit 'bonus'.
  */
  private final class innerMouseListener extends MouseAdapter
  {
   /**
    * Nombre maximum de clics de souris a 'supporter'.
    */
    private static final int LIMITE= 6;

   /**
    * Decompte le nombre de clics, modulo LIMITE.
    */
    private int clickCount= 0;


    public final void mouseClicked(MouseEvent e)
    { if (++this.clickCount > innerMouseListener.LIMITE)
      { this.clickCount= 0;
        SidePanel.this.tiles[0].jumpToTile(0, 3);
        SidePanel.this.tiles[1].jumpToTile(1, 0);
        SidePanel.this.tiles[2].jumpToTile(1, 0);
        SidePanel.this.timer.start();
        SidePanel.this.repaint();
      }// if (++this.clickCount > innerMouseListener.LIMITE)
    }
  }// private final class innerMouseListener


}// class GraphicSidePanel extends JPanel



/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */