/*
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 
 * Created on 11 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.isola.skin.redrobot;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

import org.skreel.k.simpleSwing.*;
import org.skreel.k.isola.core.Game;


/* # classe GraphicMenubar - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 *
 * @author k
 */
public class Menubar extends JMenuBar
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Necessaire pour les elements des menus (voir implementation).
  */
  private SkinMediator mediator;



 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Construit et initialise la barre de menu de l'application Isola.
  *
  * @param mediator         Mediateur de la fenetre et du jeu.
  */
  public Menubar(SkinMediator mediator)
  { super();

    this.mediator= mediator;
    this.add(this.createGameMenu(mediator));
    this.add(this.createSetsMenu(mediator));
    this.add(this.createHelpMenu(mediator));
  }



 /* # methodes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Cree le menu "Game" de la barre de menu.
  *
  * @return                 menu "Game".
  */
  private final JMenu createGameMenu(SkinMediator mediator)
  { JMenu      retour= new JMenu("Game");
    JMenuItem  machin;

    retour.setMnemonic(KeyEvent.VK_G);

    machin= retour.add(new AAction("New Game", KeyEvent.VK_N, ActionEvent.CTRL_MASK)
    { public void actionPerformed(ActionEvent e)
      { Menubar.this.mediator.newgame(); }
    });
    mediator.register("MenuItem_NewGame", machin);

    machin= retour.add(new AAction("Restart" , KeyEvent.VK_R, ActionEvent.CTRL_MASK)
    { public void actionPerformed(ActionEvent e)
      { Menubar.this.mediator.restart(); }
    });
    mediator.register("MenuItem_Restart", machin);

    retour.addSeparator();
    machin= retour.add(new AAction("Undo"    , 0, KeyEvent.VK_Z, ActionEvent.CTRL_MASK)
    { public void actionPerformed(ActionEvent e)
      { Menubar.this.mediator.undo(); }
    });
    mediator.register("MenuItem_Undo", machin);

    machin= retour.add(new AAction("Redo"    , 0, KeyEvent.VK_Y, ActionEvent.CTRL_MASK)
    { public void actionPerformed(ActionEvent e)
      { Menubar.this.mediator.redo(); }
    });
    mediator.register("MenuItem_Redo", machin);

    retour.addSeparator();
    machin= retour.add(new AAction("Quit"    , KeyEvent.VK_Q, ActionEvent.CTRL_MASK)
    { public void actionPerformed(ActionEvent e)
      { Menubar.this.mediator.quit(); }
    });

    return (retour);
  }


 /**
  * Cree le menu "Settings" de la barre de menu.
  *
  * @return                 menu "Settings"
  */
  private final JMenu createSetsMenu(SkinMediator mediator)
  { JMenu       retour= new JMenu("Settings");
    JMenu       menu_1, menu_2;
    JMenuItem   machin;
    ButtonGroup groupe;

    retour.setMnemonic(KeyEvent.VK_S);

    menu_1= new JMenu("Player 1");
    groupe= new ButtonGroup();
      machin= new JRadioButtonMenuItem(new AAction("Hu-man"  , KeyEvent.VK_H)
      { public void actionPerformed(ActionEvent e)
        { Menubar.this.mediator.setPlayerHuman(Game.PLAYER_ONE, true); }
      });
      mediator.register("MenuItem_P1_Human", machin);
      groupe.add(menu_1.add(machin));

      machin= new JRadioButtonMenuItem(new AAction("Computer", KeyEvent.VK_C)
      { public void actionPerformed(ActionEvent e)
        { Menubar.this.mediator.setPlayerHuman(Game.PLAYER_ONE, false); }
      });
      mediator.register("MenuItem_P1_Computer", machin);
      groupe.add(menu_1.add(machin));

    menu_1.addSeparator();

      menu_2= new JMenu("Comp. Skill");
      mediator.register("Menu_P1_setSkill", menu_2);
      groupe= new ButtonGroup();
        machin= new JRadioButtonMenuItem(new AAction("Random", KeyEvent.VK_R)
        { public void actionPerformed(ActionEvent e)
          { Menubar.this.mediator.setPlayerSkill(Game.PLAYER_ONE, 0); }
        });
        mediator.register("MenuItem_P1_Random", machin);
        groupe.add(menu_2.add(machin));

        machin= new JRadioButtonMenuItem(new AAction("Simple", KeyEvent.VK_S)
        { public void actionPerformed(ActionEvent e)
          { Menubar.this.mediator.setPlayerSkill(Game.PLAYER_ONE, 1); }
        });
        mediator.register("MenuItem_P1_Simple", machin);
        groupe.add(menu_2.add(machin));

        machin= new JRadioButtonMenuItem(new AAction("MinMax", KeyEvent.VK_M)
        { public void actionPerformed(ActionEvent e)
          { Menubar.this.mediator.setPlayerSkill(Game.PLAYER_ONE, 2); }
        });
        mediator.register("MenuItem_P1_MinMax", machin);
        groupe.add(menu_2.add(machin));

      menu_1.add(menu_2);
    retour.add(menu_1);

    menu_1= new JMenu("Player 2");
    groupe= new ButtonGroup();
      machin= new JRadioButtonMenuItem(new AAction("Hu-man"  , KeyEvent.VK_H)
      { public void actionPerformed(ActionEvent e)
        { Menubar.this.mediator.setPlayerHuman(Game.PLAYER_TWO, true); }
      });
      mediator.register("MenuItem_P2_Human", machin);
      groupe.add(menu_1.add(machin));

      machin= new JRadioButtonMenuItem(new AAction("Computer", KeyEvent.VK_C)
      { public void actionPerformed(ActionEvent e)
        { Menubar.this.mediator.setPlayerHuman(Game.PLAYER_TWO, false); }
      });
      mediator.register("MenuItem_P2_Computer", machin);
      groupe.add(menu_1.add(machin));

    menu_1.addSeparator();

      menu_2= new JMenu("Comp. Skill");
      mediator.register("Menu_P2_setSkill", menu_2);
      groupe= new ButtonGroup();
        machin= new JRadioButtonMenuItem(new AAction("Random", KeyEvent.VK_R)
        { public void actionPerformed(ActionEvent e)
          { Menubar.this.mediator.setPlayerSkill(Game.PLAYER_TWO, 0); }
        });
        mediator.register("MenuItem_P2_Random", machin);
        groupe.add(menu_2.add(machin));

        machin= new JRadioButtonMenuItem(new AAction("Simple", KeyEvent.VK_S)
        { public void actionPerformed(ActionEvent e)
          { Menubar.this.mediator.setPlayerSkill(Game.PLAYER_TWO, 1); }
        });
        mediator.register("MenuItem_P2_Simple", machin);
        groupe.add(menu_2.add(machin));

        machin= new JRadioButtonMenuItem(new AAction("MinMax", KeyEvent.VK_M)
        { public void actionPerformed(ActionEvent e)
          { Menubar.this.mediator.setPlayerSkill(Game.PLAYER_TWO, 2); }
        });
        mediator.register("MenuItem_P2_MinMax", machin);
        groupe.add(menu_2.add(machin));

      menu_1.add(menu_2);
    retour.add(menu_1);

    retour.addSeparator();

    groupe= new ButtonGroup();
    machin= new JRadioButtonMenuItem(new AAction("P1 plays first", KeyEvent.VK_1)
    { public void actionPerformed(ActionEvent e)
      { Menubar.this.mediator.setFirstPlayer(Game.PLAYER_ONE); }
    } );
    mediator.register("MenuItem_P1_First", machin);
    groupe.add(retour.add(machin));

    machin= new JRadioButtonMenuItem(new AAction("P2 plays first", KeyEvent.VK_2)
    { public void actionPerformed(ActionEvent e)
      { Menubar.this.mediator.setFirstPlayer(Game.PLAYER_TWO); }
    } );
    mediator.register("MenuItem_P2_First", machin);
    groupe.add(retour.add(machin));

    return (retour);
  }


 /**
  * Cree le menu "Help" de la barre de menu.
  *
  * @return                 menu "Help"
  */
  private final JMenu createHelpMenu(SkinMediator mediator)
  { JMenu     retour= new JMenu("Help");

    retour.setMnemonic(KeyEvent.VK_H);

    retour.add(new AAction("Rules", KeyEvent.VK_R, KeyEvent.VK_F1, 0)
    { public void actionPerformed(ActionEvent e)
      { Menubar.this.mediator.displayRules(); }
    });

    retour.addSeparator();
    retour.add(new AAction("About...", KeyEvent.VK_A)
    { public void actionPerformed(ActionEvent e)
      { Menubar.this.mediator.displayAbout(); }
    });
    
    return (retour);
  }



}// public class GraphicMenubar extends JMenuBar



/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */