/*
 * BSD License
 *  ( http://www.opensource.org/licenses/bsd-license.html )
 *
 * Software copyright (c) 2002, k` (agggka@hotmail.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution
 *  3. The name of the author may not be used to endorse or promote
 *     products derived from this software without specific prior
 *     written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 
 * Created on 11 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.isola.skin.redrobot;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;

import javax.swing.JPanel;

import org.skreel.k.isola.core.Game;
import org.skreel.k.isola.core.GamePoint;


/* # classe GraphicGameBoard - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 *
 * @author k
 */
class GameBoard extends JPanel
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Cache: Etat courant du plateau.
  */
  private int[][] gameBoard;

 /**
  * Cache: positions des joueurs.
  */
  private GamePoint[] positions;

 /**
  * Les images pour le plateau de jeu, et les pions des joueurs.
  */
  private Image[] images;



 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Construit un nouvel affichage de plateau de jeu.
  */
  public GameBoard(SkinMediator mediator)
  { this.gameBoard= new int[Game.BOARD_ROWS][Game.BOARD_COLS];
    this.positions= new GamePoint[2];

    this.positions[Game.PLAYER_ONE]= new GamePoint(Game.POSITIONS[Game.PLAYER_ONE]);
    this.positions[Game.PLAYER_TWO]= new GamePoint(Game.POSITIONS[Game.PLAYER_TWO]);

    mediator.register("gameBoard", this);
  }



 /* # methodes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Chargement des images, utilisation d'un <code>MediaTracker</code>
  *  pour un chargement EFFECTIF.
  */
  private final void loadRessources()
  { Toolkit       toolkit= java.awt.Toolkit.getDefaultToolkit();
    MediaTracker  tracker= new MediaTracker(this);

    images= new Image[4];

    images[0]= toolkit.getImage( GameBoard.class.getResource("/images/gameboard/case0.png") );
    images[1]= toolkit.getImage( GameBoard.class.getResource("/images/gameboard/case1.png") );
    images[2]= toolkit.getImage( GameBoard.class.getResource("/images/gameboard/pion0.png") );
    images[3]= toolkit.getImage( GameBoard.class.getResource("/images/gameboard/pion1.png") );

    tracker.addImage(images[0], 0);
    tracker.addImage(images[1], 1);
    tracker.addImage(images[2], 2);
    tracker.addImage(images[3], 3);

    try
    { tracker.waitForAll(); }
    catch(InterruptedException ie)
    { /* bah, this is hopeless */ }
  }


 /**
  * Met a jour l'etat du plateau et la positions des deux joueurs. 
  *
  * @param gameBoard        etat du plateau de jeu
  * @param positions        positions des deux joueurs
  */
  void update(int[][] gameBoard, GamePoint[] positions)
  { System.arraycopy(gameBoard[0], 0, this.gameBoard[0], 0, Game.BOARD_COLS);
    System.arraycopy(gameBoard[1], 0, this.gameBoard[1], 0, Game.BOARD_COLS);
    System.arraycopy(gameBoard[2], 0, this.gameBoard[2], 0, Game.BOARD_COLS);
    System.arraycopy(gameBoard[3], 0, this.gameBoard[3], 0, Game.BOARD_COLS);
    System.arraycopy(gameBoard[4], 0, this.gameBoard[4], 0, Game.BOARD_COLS);
    System.arraycopy(gameBoard[5], 0, this.gameBoard[5], 0, Game.BOARD_COLS);

    System.arraycopy(positions, 0, this.positions, 0, 2);
    this.repaint();
  }


 /**
  * Dessine le plateau de jeu, c'est a dire les cases, detruites ou non, et
  *  les deux joueurs.
  *
  * @param g                "cible" affichant le dessin
  */
  public void paint(Graphics g)
  { if (null == images)
    { g.drawString("loading images...", 115, 120); 
      this.loadRessources();
    }// if (null == images)

   /* ligne 1 - - - - - - - - - - - - - - - - - - - - - - - */
    g.drawImage(images[ this.gameBoard[0][0] ],   0,   0, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[0][1] ],  40,   0, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[0][2] ],  80,   0, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[0][3] ], 120,   0, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[0][4] ], 160,   0, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[0][5] ], 200,   0, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[0][6] ], 240,   0, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[0][7] ], 280,   0, Color.WHITE, this);
   /* ligne 2 - - - - - - - - - - - - - - - - - - - - - - - */
    g.drawImage(images[ this.gameBoard[1][0] ],   0,  40, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[1][1] ],  40,  40, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[1][2] ],  80,  40, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[1][3] ], 120,  40, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[1][4] ], 160,  40, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[1][5] ], 200,  40, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[1][6] ], 240,  40, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[1][7] ], 280,  40, Color.WHITE, this);
   /* ligne 3 - - - - - - - - - - - - - - - - - - - - - - - */
    g.drawImage(images[ this.gameBoard[2][0] ],   0,  80, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[2][1] ],  40,  80, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[2][2] ],  80,  80, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[2][3] ], 120,  80, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[2][4] ], 160,  80, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[2][5] ], 200,  80, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[2][6] ], 240,  80, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[2][7] ], 280,  80, Color.WHITE, this);
   /* ligne 4 - - - - - - - - - - - - - - - - - - - - - - - */
    g.drawImage(images[ this.gameBoard[3][0] ],   0, 120, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[3][1] ],  40, 120, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[3][2] ],  80, 120, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[3][3] ], 120, 120, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[3][4] ], 160, 120, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[3][5] ], 200, 120, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[3][6] ], 240, 120, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[3][7] ], 280, 120, Color.WHITE, this);
   /* ligne 5 - - - - - - - - - - - - - - - - - - - - - - - */
    g.drawImage(images[ this.gameBoard[4][0] ],   0, 160, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[4][1] ],  40, 160, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[4][2] ],  80, 160, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[4][3] ], 120, 160, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[4][4] ], 160, 160, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[4][5] ], 200, 160, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[4][6] ], 240, 160, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[4][7] ], 280, 160, Color.WHITE, this);
   /* ligne 6 - - - - - - - - - - - - - - - - - - - - - - - */
    g.drawImage(images[ this.gameBoard[5][0] ],   0, 200, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[5][1] ],  40, 200, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[5][2] ],  80, 200, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[5][3] ], 120, 200, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[5][4] ], 160, 200, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[5][5] ], 200, 200, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[5][6] ], 240, 200, Color.WHITE, this);
    g.drawImage(images[ this.gameBoard[5][7] ], 280, 200, Color.WHITE, this);

    try
    { g.drawImage(images[2],
                  10 * (this.positions[Game.PLAYER_ONE].x << 2),
                  10 * (this.positions[Game.PLAYER_ONE].y << 2),
                  java.awt.Color.WHITE,
                  this);
      g.drawImage(images[3],
                  10 * (this.positions[Game.PLAYER_TWO].x << 2),
                  10 * (this.positions[Game.PLAYER_TWO].y << 2),
                  java.awt.Color.WHITE,
                  this);
    }
    catch (NullPointerException e)
    { /* I'm useless, but not for long */ }
  }


}// class GraphicGameBoard extends JPanel



/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */