/*
 * Created on 14 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.isola.skin.redrobot;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Insets;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

import javax.swing.border.Border ;


/* # classe GraphicDialog  - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 * 
 * @author k
 */
public abstract class BasicDialog extends JDialog
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

  protected Container contentPane;


 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Construit et Initialise une boite de dialogue 'basique' de l'application.
  * 
  * @param owner
  * @param title
  * @param modal
  */
  public BasicDialog(Skin owner, String title, boolean modal)
  { super(owner, title, modal, null);

    JPanel  aPanel;
    Border  machin, bidule;

    aPanel= new JPanel(new BorderLayout());
    machin= BorderFactory.createMatteBorder(0,1,0,0, Color.GRAY);
    bidule= BorderFactory.createMatteBorder(0,1,0,0, Color.WHITE);

    aPanel.add(this.createMainPanel()  , BorderLayout.CENTER);
    aPanel.add(this.createButtonPanel(), BorderLayout.SOUTH);
    aPanel.setBorder(BorderFactory.createCompoundBorder(machin, bidule));

    this.contentPane= this.getContentPane();
    this.contentPane.setLayout(new BoxLayout(this.contentPane, BoxLayout.X_AXIS));
    this.contentPane.add(this.createSidePanel());
    this.contentPane.add(aPanel);

    this.pack();
    this.setSize(345, 335);
    this.setDefaultCloseOperation(HIDE_ON_CLOSE);
  }



 /* # getter / setter - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Redimensionne la boite de dialogue en tenant compte des bordures.
  *
  * @param width
  * @param height
  */
  public void setSize(int width, int height)
  { Insets insets= this.getInsets();
    super.setSize(width + insets.left, height + insets.top);
  }


 /**
  * 
  * 
  * @return
  */
  protected abstract String getImagePath();


 /**
  * 
  * 
  * @return
  */
  protected abstract String getText();



 /* # methodes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * 
  * @return
  */
  protected JComponent createSidePanel()
  { JLabel    retour= new JLabel();
    ImageIcon machin;

    try
    { machin= new ImageIcon(this.getClass().getResource(this.getImagePath()));
      retour.setIcon(machin);
    }
    catch (Exception e)
    { retour.setText("Error loading Image"); }

    return (retour);
  }


 /**
  * Cree le contenu principal de la fenetre.
  *
  * @return
  */
  protected JComponent createMainPanel()
  { JPanel    retour;

    retour= new JPanel();
    retour.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

    return (retour);
  }


 /**
  * Cree un panel vide charge de "stocker" les boutons de la boite de
  *  dialogue.
  * 
  * @return
  */
  protected JComponent createButtonPanel()
  { JPanel retour= new JPanel();

    retour.setLayout(new BoxLayout(retour, BoxLayout.X_AXIS));
    retour.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 20));

    return (retour);
  }


 /**
  * Creation d'un bouton de femeture de boite de dialogue, si l'utilisateur
  *  appuie sur la touche "Echap" de son clavier, l'effet est le meme.
  *
  * @param name
  * @return
  */
  protected JButton createCloseButton(String name)
  { JButton     retour;
    JRootPane   racine;
    Action      action;
    KeyStroke   stroke;
    Insets      margin;

    racine= this.getRootPane();
    stroke= KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0);
    action= new AbstractAction(name)
    { public void actionPerformed(ActionEvent e)
      { BasicDialog.this.setVisible(false); }
    };

    retour= new JButton(action);
    margin= retour.getMargin();
    margin.left += 8;
    margin.right+= 8;
    retour.setMargin(margin);

    racine.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(stroke, name);
    racine.getActionMap().put(name, action);

    return (retour);
  }


}// public abstract class GraphicDialog extends JDialog



/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */