/*
 * BSD License
 *  ( http://www.opensource.org/licenses/bsd-license.html )
 *
 * Software copyright (c) 2002, k` (agggka@hotmail.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution
 *  3. The name of the author may not be used to endorse or promote
 *     products derived from this software without specific prior
 *     written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 
 * Created on 7 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.isola.core;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/* # classe GamePoint  - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 * Une position sur le plateau de jeu, les positions obeissent a une
 *  arithmetique 'discrete': la distance entre deux points est le maximum
 *  des differences des coordonnees respectives.
 *
 * @author k
 */
public class GamePoint
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Abscisse du point.
  *  Si aucune coordonnee n'est fixee, alors la valeur par defaut sera 0.
  */
  public int x;


 /**
  * Ordonnee du point.
  *  Si aucune coordonnee n'est fixee, alors la valeur par defaut sera 0.
  */
  public int y;



 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Construit et initialise un point a la position (0,0) du plateau.
  */
  public GamePoint()
  { this(0, 0); }


 /**
  * Construit et initialise un point a la meme position que le point p.
  * 
  * @param p                un point
  */
  public GamePoint(GamePoint p)
  { this(p.x, p.y); }


 /**
  * Construit et initialise un point a la position (x,y) du plateau.
  *
  * @param x                abscisse du point
  * @param y                ordonnee du point
  */
  public GamePoint(int x, int y)
  { this.move(x, y); }



 /* # getter / setter - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Retourne les coordonnees du point sous la forme d'un tableau de deux
  *  entiers.
  *
  * @return                 coordonnees du point
  */
  public int[] getXY()
  { int[] retour= {this.x, this.y};
    return (retour);    
  }



 /* # methodes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Calcule la distance entre les points p1 et p2, c'est a dire le nombre
  *  minimum de deplacements pour aller de l'un a l'autre.
  *
  * @param p1               point 1
  * @param p2               point 2
  * @return                 nombre minimum de deplacements a effectuer
  *                         pour passer du point 1 au point 2
  */
  public static int distance(GamePoint p1, GamePoint p2)
  { return distance(p1.x, p1.y, p2.x, p2.y); }


 /**
  * Calcule la distance entre les points (x1,y1) et (x2,y2), c'est a dire
  *  le nombre minimum de deplacements pour aller de l'un a l'autre.
  *
  * @param x1               abscisse du point 1
  * @param y1               ordonnee du point 1
  * @param x2               abscisse du point 2
  * @param y2               ordonnee du point 2
  * @return                 nombre minimum de deplacements a effectuer
  *                         pour passer du point 1 au point 2
  */
  public static int distance(int x1, int y1, int x2, int y2)
  { return (Math.max(Math.abs(x1-x2), Math.abs(y1-y2))); }  


 /**
  * Calcule la distance entre ce point et le point de position (x,y).
  * 
  * @param x                abscisse de l'autre point
  * @param y                ordonnee de l'autre point
  * @return                 nombre minimum de deplacements a effectuer
  *                         pour passer d'un point a l'autre
  */
  public int distance(int x, int y)
  { return (GamePoint.distance(this.x, this.y, x, y)); }


 /**
  * Calcule la distance entre ce point et le point p.
  *
  * @param p                l'autre point
  * @return                 nombre minimum de deplacements a effectuer
  *                         pour passer d'un point a l'autre
  */
  public int distance(GamePoint p)
  { return (GamePoint.distance(this, p)); }


 /**
  * Determine si les coordonnees du point sont egales a la position (x,y).
  *
  * @param x                abscisse
  * @param y                ordonnee
  * @return                 true si les coordonnees sont identiques
  */
  public final boolean equals(int x, int y)
  { return (0 == ((this.x ^ x) | (this.y ^ y))); }


 /**
  * Determine si deux points sont egaux, c'est a dire, si leurs coordonnees
  *  sont identiques.
  *
  * @param p                point auquel comparer le point courant
  * @return                 true si les positions des deux points
  *                         sont identiques
  */
  public boolean equals(GamePoint p)
  { return (this.equals(p.x, p.y)); }


 /**
  * Determine si deux points sont egaux, c'est a dire, si leurs coordonnees
  *  sont identiques. Surcharge de la methode equals de la classe Object.
  *
  * @param obj              point auquel comparer le point courant
  * @return                 true si les positions des deux points
  *                         sont identiques
  */
  public boolean equals(Object obj)
  { boolean retour= false;
    if (obj instanceof GamePoint && null != obj)
    { retour= this.equals((GamePoint) obj); }
    return (retour);
  }


 /**
  * Deplace le point vers la position (x,y) du plateau.
  * 
  * @param x                abscisse de la nouvelle position
  * @param y                ordonnee de la nouvelle position
  */
  public void move(int x, int y)
  { this.x= x;
    this.y= y;
  }


 /**
  * Deplace le point vers le point p.
  *
  * @param p                nouvelle position
  */
  public void move(GamePoint p)
  { this.move(p.x, p.y); }


 /**
  * Deplace le point de (dx,dy) par rapport a sa position.
  * 
  * @param dx               variation de l'abscisse du point
  * @param dy               variation de l'ordonnee du point
  */
  public void translate(int dx, int dy)
  { this.move(this.x+dx , this.y+dy); }


}// class GamePoint


/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */