/*
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 
 * Created on 10 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.isola.core;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/* # classe GameMemento  - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 * Memorisation d'un etat de jeu, facilite l'implementation d'un systeme
 *  d'annulation de coup. Un objet Memento ne peut memoriser qu'un unique
 *  etat de jeu, une fois cree on ne peut le modifier.
 *
 * @author k
 */
class GameMemento
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Plateau de jeu.
  */
  protected byte[]      gameBoard;


 /**
  * Positions des joueurs.
  */
  protected GamePoint[] positions;


 /**
  * Contexte du jeu.
  */
  protected int         gameContxt;



 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */


 /**
  * Cree et initialise un Memento avec l'etat de jeu gameState.
  *
  * @param gameState        etat de jeu cible a enregistrer
  */
  public GameMemento(GameState gameState)
  { this.gameBoard= new byte[6];
    this.positions= new GamePoint[2];

    System.arraycopy(gameState.gameBoard, 0, this.gameBoard, 0, 6);
    this.positions[Game.PLAYER_ONE]= new GamePoint(gameState.positions[Game.PLAYER_ONE]);
    this.positions[Game.PLAYER_TWO]= new GamePoint(gameState.positions[Game.PLAYER_TWO]);
    this.gameContxt= gameState.gameContxt;
  }



 /* # methodes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Restaure un etat de jeu. l'etat gameState cible est ecrase.
  *
  * @param gameState        etat de jeu cible a modifier
  */
  public void restore(GameState gameState)
  { System.arraycopy(this.gameBoard, 0, gameState.gameBoard, 0, 6);
    gameState.positions[Game.PLAYER_ONE].move(this.positions[Game.PLAYER_ONE]);
    gameState.positions[Game.PLAYER_TWO].move(this.positions[Game.PLAYER_TWO]);
    gameState.gameContxt= this.gameContxt;
  }



}// public class GameMemento



/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */