/*
 * BSD License
 *  ( http://www.opensource.org/licenses/bsd-license.html )
 *
 * Software copyright (c) 2002, k` (agggka@hotmail.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution
 *  3. The name of the author may not be used to endorse or promote
 *     products derived from this software without specific prior
 *     written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 
 * Created on 7 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.isola.core;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/* # classe GameBoard  - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 * Classe statique regroupant quelques precieuses informations a destination
 *  d'une Intelligence Artificielle.
 *
 * @author k
 */
public final class GameBoard
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Nombre de cases sur la premiere couche, entourant immediatement une
  *  position donnee.
  */
  private static final byte[] COUNT1=
  { (byte) 3,(byte) 5,(byte) 5,(byte) 5,(byte) 5,(byte) 5,(byte) 5,(byte) 3,
    (byte) 5,(byte) 8,(byte) 8,(byte) 8,(byte) 8,(byte) 8,(byte) 8,(byte) 5,
    (byte) 5,(byte) 8,(byte) 8,(byte) 8,(byte) 8,(byte) 8,(byte) 8,(byte) 5,
    (byte) 5,(byte) 8,(byte) 8,(byte) 8,(byte) 8,(byte) 8,(byte) 8,(byte) 5,
    (byte) 5,(byte) 8,(byte) 8,(byte) 8,(byte) 8,(byte) 8,(byte) 8,(byte) 5,
    (byte) 3,(byte) 5,(byte) 5,(byte) 5,(byte) 5,(byte) 5,(byte) 5,(byte) 3 };


 /**
  * Nombre de cases sur la seconde couche, les cases se trouvant a un
  *  deplacement d'ecart d'une position donnee.
  */
  private static final byte[] COUNT2=
  { (byte) 5,(byte) 6,(byte) 9,(byte) 9,(byte) 9,(byte) 9,(byte) 6,(byte) 5,
    (byte) 6,(byte) 7,(byte)11,(byte)11,(byte)11,(byte)11,(byte) 7,(byte) 6,
    (byte) 9,(byte)11,(byte)16,(byte)16,(byte)16,(byte)16,(byte)11,(byte) 9,
    (byte) 9,(byte)11,(byte)16,(byte)16,(byte)16,(byte)16,(byte)11,(byte) 9,
    (byte) 6,(byte) 7,(byte)11,(byte)11,(byte)11,(byte)11,(byte) 7,(byte) 6,
    (byte) 5,(byte) 6,(byte) 9,(byte) 9,(byte) 9,(byte) 9,(byte) 6,(byte) 5 };


 /**
  * Position des cases directement adjacentes a une position donnee, on
  *  utilise la position des bits dans un octet.
  */
  private static final int[]  LAYER1=
  { 0x000B, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x0016,
    0x006B, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00D6,
    0x006B, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00D6,
    0x006B, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00D6,
    0x006B, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00D6,
    0x0068, 0x00F8, 0x00F8, 0x00F8, 0x00F8, 0x00F8, 0x00F8, 0x00D0 };


 /**
  * Position des cases directement situees a un mouvement d'ecart d'une
  *  position donnee, on utilise la position des bits dans un 'short'.
  */
  private static final int[]  LAYER2=
  { 0x00A7, 0x00AF, 0x01FF, 0x01FF, 0x01FF, 0x01FF, 0x015E, 0x015A,
    0x02A7, 0x02AF, 0x07FF, 0x07FF, 0x07FF, 0x07FF, 0x055E, 0x055C,
    0x3AA7, 0x7AAF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF557, 0xE55C,
    0x3AA7, 0x7AAF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF557, 0xE55C,
    0x3AA0, 0x7AA0, 0xFFE0, 0xFFE0, 0xFFE0, 0xFFE0, 0xF540, 0x7540,
    0x9A80, 0x7A80, 0xFF80, 0xFF80, 0xFF80, 0xFF80, 0xF500, 0xE500 };



 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Interdit la creation d'instance.
  */
  private GameBoard()
  { /* thou shalt not instanciate thy class */ }



 /* # getter / setter - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Recupere le nombre de cases directement adjacentes a la position (x,y).
  *
  * @param x                abscisse du point a considerer
  * @param y                ordonnee du point a considerer
  */
  public static final int getCount1(int x, int y)
  { int retour= 0;

    try
    { retour= GameBoard.COUNT1[8*y + x]; }
    catch (ArrayIndexOutOfBoundsException e)
    { /* I have no idea of what you're talking about */ }

    return (retour);
  }


 /**
  * Recupere le nombre de cases directement adjacentes au point p.
  *
  * @param p                point a considerer
  */
  public static final int getCount1(GamePoint p)
  { return (GameBoard.getCount1(p.x, p.y)); }


 /**
  * Recupere le nombre de cases situees a un mouvement d'ecart de la
  *  position (x,y).
  *
  * @param x                abscisse du point a considerer
  * @param y                ordonnee du point a considerer
  */
  public static final int getCount2(int x, int y)
  { int retour= 0;

    try
    { retour= GameBoard.COUNT2[8*y + x]; }
    catch (ArrayIndexOutOfBoundsException e)
    { /* I have no idea of what you're talking about */ }

    return (retour);
  }


 /**
  * Recupere le nombre de cases situees a un mouvement d'ecart du point p.
  *
  * @param p                point a considerer
  */
  public static final int getCount2(GamePoint p)
  { return (GameBoard.getCount2(p.x, p.y)); }


 /**
  * Recupere le nombre de cases directement adjacentes a la position (x,y).
  *
  * @param x                abscisse du point a considerer
  * @param y                ordonnee du point a considerer
  */
  public static final int getLayer1(int x, int y)
  { int retour= 0;
    try
    { retour= GameBoard.LAYER1[8*y + x]; }
    catch (ArrayIndexOutOfBoundsException e)
    { /* I have no idea of what you're talking about */ }
    return (retour);
  }


 /**
  * Recupere le nombre de cases directement adjacentes au point p.
  *
  * @param p                point a considerer
  */
  public static final int getLayer1(GamePoint p)
  { return (GameBoard.getLayer1(p.x, p.y)); }


 /**
  * Recupere le nombre de cases directement adjacentes a la position (x,y).
  *
  * @param x                abscisse du point a considerer
  * @param y                ordonnee du point a considerer
  */
  public static final int getLayer2(int x, int y)
  { int retour= 0;
    try
    { retour= GameBoard.LAYER2[8*y + x]; }
    catch (ArrayIndexOutOfBoundsException e)
    { /* I have no idea of what you're talking about */ }
    return (retour);
  }


 /**
  * Recupere le nombre de cases directement adjacentes au point p.
  *
  * @param p                point a considerer
  */
  public static final int getLayer2(GamePoint p)
  { return (GameBoard.getLayer2(p.x, p.y)); }


}// public class GameBoard


/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */