/*
 * BSD License
 *  ( http://www.opensource.org/licenses/bsd-license.html )
 *
 * Software copyright (c) 2002, k` (agggka@hotmail.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution
 *  3. The name of the author may not be used to endorse or promote
 *     products derived from this software without specific prior
 *     written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 
 * Created on 6 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.isola.core;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

import java.util.Observable;

import org.skreel.k.isola.Mediator;


/* # classe Game - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 * 
 * @author k
 */
public class Game extends Observable
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Dimensions du plateau: 8 colonnes.
  */
  public final static int BOARD_COLS= 8;

 /**
  * Dimensions du plateau: 6 lignes.
  */
  public final static int BOARD_ROWS= 6;


 /**
  * Identifiant du joueur numero Un, c'est a dire le joueur initialement
  *  place a gauche du plateau de jeu.
  */
  public final static int PLAYER_ONE= 0;

 /**
  * Identifiant du joueur numero Deux, c'est a dire le joueur initialement
  *  place a droite du plateau de jeu.
  */
  public final static int PLAYER_TWO= 1;


 /**
  * Positions initiales des deux joueurs sur le plateau.
  */
  public static final GamePoint[] POSITIONS= {new GamePoint(0, 2), new GamePoint(7, 3)};


 /**
  * Contexte de jeu: pas de contexte.
  */
  public final static int NO_GAME_CONTEXT=  0;

 /**
  * Contexte de jeu: joueur Un se deplace.
  */
  public final static int PLAYER_ONE_MOVE=  1;

 /**
  * Contexte de jeu: joueur Un detruit une case.
  */
  public final static int PLAYER_ONE_PUSH=  3;

 /**
  * Contexte de jeu: joueur Un gagne la partie.
  */
  public final static int PLAYER_ONE_WINS=  5;


 /**
  * Contexte de jeu: joueur Deux se deplace.
  */
  public final static int PLAYER_TWO_MOVE=  2;

 /**
  * Contexte de jeu: joueur Deux detruit une case.
  */
  public final static int PLAYER_TWO_PUSH=  4;

 /**
  * Contexte de jeu: joueur Deux detruit une case.
  */
  public final static int PLAYER_TWO_WINS=  6;


 /**
  * Contexte de jeu: joueur Un a tente un coup illegal.
  */
  public static final int PLAYER_ONE_WRNG= -1;

 /**
  * Contexte de jeu: joueur Deux a tente un coup illegal.
  */
  public static final int PLAYER_TWO_WRNG= -2;


 /**
  * Les deux joueurs en tant que tels.
  */
//  protected Player[]  gamePlyrs;


 /**
  * Etat courant du jeu: positions des joueurs, etat du plateau.
  */
  protected GameState gameState;


 /**
  * Objet Essentiellement a l'envoi de message signalant des actions sans
  *  "consequences", c'est a dire un coup illegal, ou la declaration du
  *  vainqueur.
  */
  protected GameState fakeState;


 /**
  * Identifiant du joueur debutant la partie.
  */
  protected int firstPlayer;


 /**
  * Pile de memento pour la gestion de l'annulation.
  */
  protected MementoStack undoStack;

 /**
  * Pile de memento pour la gestion de "l'annulation d'annulation".
  */
  protected MementoStack redoStack;



 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Construit et initialise un nouveau jeu, playerId determine lequel des
  *  deux joueurs commence.
  *
  * @param mediator         coordinateur de l'application
  */
  public Game(Mediator mediator)
  { super();
//    this.gamePlyrs= new Player[2];
    this.gameState= new GameState();
    this.fakeState= new GameState();
    this.undoStack= new MementoStack();
    this.redoStack= new MementoStack();

    this.addObserver(mediator);
    mediator.register("Game", this);
  }



 /* # getter / setter - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Determine le joueur qui debute la partie.
  *
  * @param playerId         identifiant du joueur
  */
  public void setFirstPlayer(int playerId)
  { this.firstPlayer= (playerId & 0x01); }


 /**
  * Indique le joueur qui debute la partie.
  *
  * @return                 identifiant du joueur
  */
  public int getFirstPlayer()
  { return (this.firstPlayer); }



 /* # methodes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Debute une partie.
  *
  * @param playerId         identifiant du joueur debutant la partie
  */
  public void start(int playerId)
  { int         courant= playerId;
    GameMemento machin;

// TODO ...
  }


 /**
  * Recommence la partie.
  */
  public void reStart()
  { this.reset();
    this.start(this.firstPlayer);
  }


 /**
  * Remise a zero du jeu.
  */
  public void reset()
  { this.gameState.reset();
    this.notifyObservers(this.gameState);
  }


 /**
  * Annule le coup precedent, si ce dernier existe.
  */
  public void undo()
  { GameMemento machin;
    if (!this.undoStack.empty())
    { machin= this.undoStack.popMemento();
      this.redoStack.pushMemento(machin);
      machin.restore(this.gameState);
      this.notifyObservers(this.gameState);
    }// if (!this.undoStack.empty())
  }


 /**
  * Retablit le dernier coup annule, si ce dernier existe.
  */
  public void redo()
  { GameMemento machin;
    if (!this.redoStack.empty())
    { machin= this.redoStack.popMemento();
      this.undoStack.pushMemento(machin);
      machin.restore(this.gameState);
      this.notifyObservers(this.gameState);
    }// if (!this.redoStack.empty())
  }



}// class Game


/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */