/*
 * BSD License
 *  ( http://www.opensource.org/licenses/bsd-license.html )
 *
 * Software copyright (c) 2002, k` (agggka@hotmail.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution
 *  3. The name of the author may not be used to endorse or promote
 *     products derived from this software without specific prior
 *     written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *
 * Created on 13 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.isola;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;

import org.skreel.k.isola.core.*;


/* # classe Mediator - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 * 
 * @author k
 */
public abstract class Mediator implements Observer
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Stocke les composants a coordonner.
  */
  protected Hashtable hashtable;

 /**
  * Reference facile d'acces au coeur du jeu.
  */
  protected Game game;


 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Cree un motif Mediateur gerant les interactions entre le coeur du jeu
  *  et sa representation.
  */
  public Mediator()
  { this.hashtable= new Hashtable(); }



 /* # getter / setter - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Determine lequel des deux joueurs debute la partie.
  *
  * @param playerId         identifiant de joueur
  */
  public void setFirstPlayer(int playerId)
  {
  }


 /**
  * Organise l'etat des composants reglant la nature du joueur playerId.
  *  Si ce joueur est humain, alors il n'est pas coherent d'avoir acces au
  *  reglage de la force de la machine pour ce joueur.
  *
  * @param playerId         identifiant de joueur
  * @param value            true si le joueur est humain
  */
  public void setPlayerHuman(int playerId, boolean value)
  {
  }


 /**
  * Determine la configuration du joueur considere.
  *
  * @param playerId         identifiant de joueur
  * @param skill            force du joueur (valable pour une IA)
  */
  public void setPlayerSkill(int playerId, int skill)
  {
  }



 /* # methodes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Declaration du jeu au Mediateur.
  *
  * @param key              cle d'identification du composant.
  * @param game             coeur du jeu.
  */
  public void register(String key, Game game)
  { this.game= game; }


 /**
  * Declaration d'un composant au Mediateur. S'il y collision, alors
  *  l'element qui se trouvait deja dans la liste est remplace.
  *
  * @param key              cle d'identification du composant.
  * @param component        composant a coordonner.
  */
  public void register(String key, Object component)
  { this.hashtable.put(key, component); }


 /**
  * Initialisation de l'etat des composants.
  */
  public void initialize()
  { try
    { this.game.reset(); }
    catch (Exception e)
    { /* We are walking on a thin line */ }
  }


 /**
  * Affiche les changement survenu a l'objet observe.
  *
  * @param game             le jeu observe
  * @param gameState        l'etat courant du dit jeu observe
  *
  * @see java.util.Observer#update(java.util.Observable, java.lang.Object)
  */
  public void update(Observable game, Object gameState)
  { if (gameState instanceof GameState && null != gameState)
    { this.update((GameState) gameState); }
  }


 /**
  * Affiche les changement survenu a l'objet observe. Version a surcharger.
  *
  * @param gameState        l'etat courant du dit jeu observe
  */
  protected abstract void update(GameState gameState);



 /**
  * Instructions a realiser quand l'utilisateur demande une nouvelle partie.
  */
  public void newgame()
  {
// TODO
System.out.println("newGame");
  }


 /**
  * Instructions a realiser quand l'utilisateur demande a rejouer la partie.
  */
  public void restart()
  {
// TODO
System.out.println("reStart");
  }


 /**
  * Instructions a realiser quand l'utilisateur demande l'annulation
  *  du dernier coup.
  */
  public void undo()
  {
  }


 /**
  * Instructions a realiser quand l'utilisateur demande a refaire
  *  le dernier coup annule.
  */
  public void redo()
  {
  }


 /**
  * Instructions a realiser quand l'utilisateur demande l'arret
  *  de l'application.
  */
  public void quit()
  { System.exit(0); }


}// public abstract class Mediator implements Observer



/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */