/*
 * BSD License
 *  ( http://www.opensource.org/licenses/bsd-license.html )
 *
 * Software copyright (c) 2002, k` (agggka@hotmail.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution
 *  3. The name of the author may not be used to endorse or promote
 *     products derived from this software without specific prior
 *     written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * 
 * Created on 6 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package org.skreel.k.isola;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

import javax.swing.UIManager;

import org.skreel.k.isola.core.*;
import org.skreel.k.isola.skin.redrobot.*;


import java.util.Properties;
import java.io.* ;


/* # classe Isola  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 * Classe principale, effectuant le lancement de l'application.
 * 
 * @author k
 */
public final class Isola
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Court texte d'aide a l'utilisation de l'application.
  */
  public static final String HELP=
      "Usage: java org.skreel.k.isola.Isola [OPTION]\n"
    + "Isola, a simple, yet fun, two players game.\n"
    + "\n"
    + "  --help                display this help and exit\n"
    + "  --about               output software information and exit\n"
    + "  --noGUI               run in text mode\n"
    + "  --LnF=LOOK_AND_FEEL   set the look and feel using a class name\n"
    + "                        (useless for text mode)\n"
    + "  --X=VALUE             set the x-coordinate of the window's top-left corner\n"
    + "                        (useless for text mode)\n"
    + "  --Y=VALUE             set the y-coordinate of the window's top-left corner\n"
    + "                        (useless for text mode)\n"
    + "  --pref=FILE           load preferences from FILE\n"
    + "\n"
    + "Report bugs to <agggka@hotmail.com>.";


 /**
  * Court texte donnant quelques informations generales sur l'application.
  */
  public static final String ABOUT=
      "Isola :\n"
    + " 2002/2003 - k` <agggka@hotmail.com>\n"
    + " This software is released under the BSD license.\n"
    + " <www.opensource.org/licenses/bsd-license.html>\n"
    + "___\n"
    + "\n"
    + " Red Robot was created by Sam Brown.\n"
    + " <www.explodingdog.com/redrobot.html>\n"
    + "___\n"
    + "\n"
    + " Red Robot's pictures are taken from R.Stevens' web comic,\n"
    + " Diesel Sweeties, and are copyrighted by their author.\n"
    + " <www.dieselsweeties.com/>";


  public static final String RULES=
      "Isola :\n"
    + "  At each turn, each player moves his pawn to\n"
    + " an adjacent empty cell.\n"
    + "\n"
    + "  After the move, the player must also remove\n"
    + "one empty cell from play.\n"
    + "\n"
    + "  The winner is the first player that isolates\n"
    + " his adversary's pawn.\n"
    + "\n"
    + "  Don't get it ? Then let the computer begin,\n"
    + " it will show you how to play.";



 /* # entree de l'application - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Point d'entree de l'application. Les parametres sont analyses puis
  *  l'application est lancee en tenant compte de ces arguments.
  * 
  * @param args             parametres
  */
  public static void main(String[] args)
  { int           coordX, coordY, length;
    String        looknf, tampon;
    boolean       useTxt;
    InputStream   stream;
    Properties    config;

    config= new Properties();
    useTxt= true;
    coordX= 0;
    coordY= 0;
    looknf= "";

    try
    { config.load( Isola.class.getResourceAsStream("/.properties") ); }
    catch (Exception e)
    { /* It's all in the mind */ }

    for (int i=0, k=args.length ; k-->0 ; )
    { length= args[i].length();

      if (args[i].equalsIgnoreCase("--help"))
      { System.out.println(Isola.HELP);
        System.exit(0);
      }
      else if (args[i].equalsIgnoreCase("--about"))
      { System.out.println(Isola.ABOUT);
        System.exit(0);
      }
      else if (args[i].equalsIgnoreCase("--noGUI"))
      { config.setProperty("noGUI", "true"); }
      else if (7 < length && args[i].startsWith("--pref="))
      { try
        { config.load( new FileInputStream(args[i].substring(7)) ); }
        catch (Exception e)
        { System.err.println("Error loading user preferences file"); }
      }
      else if (6 < length && args[i].startsWith("--LnF="))
      { looknf= args[i].substring(6); }
      else if (4 < length && (args[i].startsWith("--X=") || args[i].startsWith("--Y=")))
      { tampon= args[i].substring(4);
        try
        { Integer.parseInt(tampon);
          config.setProperty(args[i].substring(2, 3), tampon);
        }
        catch (Exception e)
        { /* now I shouldn't be there */ }
      }// if (4 < machin && (args[i].startsWith("--X=") || args[i].startsWith("--Y=")))

    }// for (int i=0, k=args.length ; k-->0 ; )

    try
    { useTxt= Boolean.valueOf(config.getProperty("noGUI")).booleanValue();
      coordX= Integer.parseInt(config.getProperty("X"));
      coordY= Integer.parseInt(config.getProperty("Y"));
      looknf= config.getProperty("LnF");
    }
    catch (Exception e)
    { /* and again, and again, until your mind is locked in */ }

    coordX= Math.max(0, coordX);
    coordX= Math.max(0, coordY);

  /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

    if (useTxt)
    {

/*
 * TODO Affichage mode texte
 */

    }// if (useTxt)
    else
    { try
      { UIManager.setLookAndFeel(looknf); }
      catch (Exception e)
      { System.err.println("Error setting look and feel, using default"); }

      SkinMediator mediator= new SkinMediator();
      Game             game= new Game(mediator);
      Skin         gameSkin= new Skin(coordX, coordY, mediator);
      mediator.initialize();


    }// if (useTxt) else

  /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

  }// public static void main(String[] args)



 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Interdit la creation d'instance.
  */
  private Isola()
  { /* thou shalt not instanciate thy class */ }


}// public final class Isola


/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */