/*
 * Created on 7 sept. 2003
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

package edu.umbc.enorth;


/* # imports - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

import java.awt.Graphics ;
import java.awt.Image ;


/* # classe BasicTile  - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/**
 * A basic tile, only a small part of an image is displayed. A neat trick
 *  to reduce the number of image file needed.
 * <p>
 *  Initial source code by Eric R. Northam (enorth1@gl.umbc.edu), found at
 *   <a href="http://userpages.umbc.edu/~enorth1/tilemapper/tutorial.htm">http://userpages.umbc.edu/~enorth1/tilemapper/tutorial.htm</a>.
 * </p>
 * 
 * @author       Eric R. Northam
 */
public class BasicTile
{
 /* # proprietes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * L'image a "decouper" virtuellement.
  */
  protected Image tileImage;


 /**
  * Deplacement par rapport au coin superieur gauche de l'image.
  */
  protected int offsetX, offsetY;


 /**
  * Dimension d'une tuile.
  */
  protected int tileHeight, tileWidth;



 /* # constructeur  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  *
  * @param img      image formees de tuiles
  * @param w        largeur d'une tuile
  * @param h        hauteur d'une tuile
  */
  public BasicTile(Image image, int width, int height)
  { this.offsetX= 0;
    this.offsetY= 0;
    this.setTileImage(image, width, height);
  }



 /* # getter / setter - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Determine quelle image rassemblant les tuiles sera utilisee.
  * <br />Les dimensions des tuiles sont inchangees.
  * 
  * @param image     image formee de tuiles
  */
  public void setTileImage(Image image)
  { this.setTileImage(image, this.tileWidth, this.tileHeight); }


 /**
  * Determine quelle image rassemblant les tuiles sera utilisee.
  * 
  * @param img     image formee de tuiles
  * @param w     largeur d'une tuile
  * @param h     hauteur d'une tuile
  */
  public void setTileImage(Image image, int width, int height)
  { this.tileImage = image;
    this.tileHeight= height;
    this.tileWidth = width;
  }


 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Retourne l'image utilisee.
  * 
  * @return    image formee de tuiles
  */
  public Image getTileImage()
  { return (this.tileImage); }



 /* # methodes  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Deplacement 'absolu' au sein de l'image, aucun test de depassement de
  *  limites n'est effectue. Le deplacement est relatif au coin superieur
  *  gauche.
  * 
  * @param x     deplacement horizontal
  * @param y     deplacement vertical
  */
  public void jumpTo(int x, int y)
  { this.offsetX= x;
    this.offsetY= y;
  }


 /**
  * Deplacement relatif au sein de l'image, aucun test de depassement de
  *  limites n'est effectue. Le deplacement est relatif a la position
  *  precedente.
  * 
  * @param dx      variation horizontale
  * @param dy      variation verticale
  */
  public void jumpBy(int dx, int dy)
  { this.offsetX+= dx;
    this.offsetY+= dy;
  }


 /**
  * Deplacement 'absolu' vers une tuile de l'image, aucun test de depassement
  *  de limites n'est effectue. Le deplacement est relatif au coin superieur
  *  gauche. L'unite de deplacement depend des valeurs de
  *  <code>tileHeight</code> et <code>tileWidth</code>.
  * 
  * @param x     position horizontale de la tuile
  * @param y     position verticale de la tuile
  */
  public void jumpToTile(int x, int y)
  { this.offsetX= x*this.tileWidth;
    this.offsetY= y*this.tileHeight;
  }


 /**
  * Deplacement 'absolu' vers une tuile de l'image, aucun test de
  *  depassement de limites n'est effectue. Le deplacement est relatif au
  *  coin superieur gauche. L'unite de deplacement depend des valeurs de
  *  <code>tileHeight</code> et <code>tileWidth</code>.
  * 
  * @param x     position horizontale de la tuile
  * @param y     position verticale de la tuile
  */
  public void jumpByTile(int dx, int dy)
  { this.offsetX+= dx*this.tileWidth;
    this.offsetY+= dy*this.tileHeight;
  }


 /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

 /**
  * Dessine la tuile courante a la position (x, y) du "contexte grapique"
  *  <code>g</code>.
  * 
  * @param g     "contexte graphique" cible
  * @param x     abscisse de l'affichage par rapport a <code>g</code>
  * @param y     ordonnee de l'affichage par rapport a <code>g</code>
  */
  public void drawTo(Graphics g, int x, int y)
  { Graphics target= g.create(x, y, this.tileWidth, this.tileHeight);
    target.drawImage(this.tileImage, -this.offsetX, -this.offsetY, null);
    target.dispose();
  }


 /* # End of Class  - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
}


/* # End of File - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
